define([
		'app',
        'FitnessService',
        'FitnessServiceConstants',
		'FitnessConstants',
        'AbstractFitnessService',
		'FitnessActivityController',
		'FitnessEntryController',
        'WeeklyGoalsService',
		'SetGoalsModalController',
        'GoalGraphService',
        'GoalGraphAccessibilityService',
        'GoalHistoryController',
        'GoalHistoryGraphService',
        'FitnessActivityGraphService',
        'FitnessRemindersService',
        'FitnessRemindersInstanceService',
        'FitnessNotificationStatusController',
        'RemindersService',
        'NotificationDeliveryDirective',
        'FitnessNavItemDateFilter',
        'FitnessCongratsService',
        'FitnessCongratsConstants'
	],
	function (app) {
		"use strict";

        app.config(function ($stateProvider) {
            $stateProvider
                .state('main.auth.fitness', {
                    url: '/fitness-activity/summary',
                    appNavIndex: 2,
                    containerClass: 'fitness',
                    data: {
                        appletName: "fitness",
                        moduleName: "Fitness Activity",
                        sectionName : "fitnessActivities",
                        icon : "learnmore-fitness"

                    },
                    views : {
                        "@main": {
                            templateUrl: 'src/container/components/content/single-column_template.html'
                        },
                        'primary@main.auth.fitness': {
                            templateUrl: 'src/modules/fitness/pages/summary/fitness-activity_template.html',
                            controller: 'FitnessActivityController'
                        }
                    }
                })
                .state('main.auth.fitness.entry', {
                    url: '^/fitness-activity/entry?id&dateRange',
                    data : {
                        panel : "primary",
                        backState : "^"
                    },
                    views : {
                        "@main": {
                            templateUrl: 'src/container/components/content/single-column_template.html'
                        },
                        'primary@main.auth.fitness.entry': {
                            templateUrl: 'src/modules/fitness/pages/entry/fitness-entry_template.html',
                            controller: 'FitnessEntryController'
                        }
                    }
                })
                .state('main.auth.fitness.notification', {
                    url: '^/fitness-activity/notification',
                    data: {
                        panel: 'primary',
                        backState : "^"
                    },
                    views: {
                        "@main": {
                            templateUrl: 'src/container/components/content/single-column_template.html'
                        },
                        'primary@main.auth.fitness.notification': {
                            templateUrl: 'src/modules/fitness/pages/notification-status/fitness-notification-status_template.html',
                            controller: 'FitnessNotificationStatusController'
                        }
                    }
                })

				.state('main.auth.fitness.goalhistory', {
					url: '^/fitness-activity/goal-history',
                    containerClass: 'fitness',
					data : {
                        panel : "primary",
                        backState : "^",
                        sectionName : 'goalHistory'
                    },
					views : {
                        "@main": {
                            templateUrl: 'src/container/components/content/single-column_template.html'
                        },
                        'primary@main.auth.fitness.goalhistory': {
                            templateUrl: 'src/modules/fitness/pages/summary/goal-history_template.html',
                            controller: 'GoalHistoryController'
                        }
					}
				});
        });
    }
);
